model Ex10_2
Real w(unit="kJ/kg") "Actual Work fro Compressor";
Real si(unit="kJ/kgK") "Enthalpy at Inlet";
Real se(unit="kJ/kgK") "Enthalpy at Outlet";
Real wrev(unit="kJ/kg") "Revesible  Work";
Real i(unit="kJ/kg") "Irreversibility";

/*Values of Entropy and Enthalpy of different streams are calculated from Steam Tables*/
parameter Real sTio(unit="kJ/kgK")= 6.8631 " Entropy at Inlet";
parameter Real hi(unit="kJ/kg")= 298.6 "Enthalpy at inlet";
parameter Real he(unit="kJ/kg")= 544.7 "Enthalpy at Exit";
parameter Real sTeo(unit="kJ/kgK")= 7.4664 " Entropy at Outlet";

parameter Real mdot(unit="kg/s")= 5 "Mass Flowrate of water";
parameter Real q(unit="kw")= -50 "Heat Loss";
parameter Real To(unit="K")= 298.2 "Standard Temperature";
parameter Real T1(unit="K")= 100+273.2 " Temperature at stage 1";
parameter Real T2(unit="K")= 200+273.2 "Temperature at stage 2";
parameter Real P1(unit="kPa")= 100 " Temperature at stage 1";
parameter Real P2(unit="kPa")= 1000 "Temperature at stage 2";
parameter Real R(unit="kJ/kgK")=0.287 "Gas Constant";

 
  equation
  se=sTeo;/*Reversible with Tj=To*/
  w=hi-he+q;
  si=sTio+R*log(P2/P1);
 
wrev=(To*(se-si))-(he-hi)+(q*(1-(To/To))); 
i=wrev-w;

end Ex10_2;
