model Ex10_6

Real Ratio1 "Ratio of Mass flow rate of Productto the  mass flow rate of water";
Real psi21(unit="kJ/kgH2O") "Increase in availability of water";
Real psi34(unit="kJ/kgH2O") "Decrease in availability of Products";
Real Idot(unit="kJ/kgH2O") "Process irreversibility per kg of water";
/*Real ds21(unit="kJ/kgH2O.K") "The change in entropy of water";
Real ds43(unit="kJ/kgH2O.K") "The change in entropy of Product";*/
Real seip(unit="kJ/kgH2O.K") "The change in entropy of Product given specific heat at constant pressure";
Real eta2ndlaw " Second Law Efficiency";

parameter Real To(unit="K")=298.15 "Standard Temperature";
parameter Real hew(unit"kJ/kg")    = 2950 " Enthalpy of Water at Exit";
parameter Real hiw(unit"kJ/kg")    = 632.2 " Enthalpy at Water at Inlet";
parameter Real hip(unit"kJ/kg")   = 1100 " Enthalpy at Product at Inlet";
parameter Real hep(unit"kJ/kg")   = 550 " Enthalpy at Product at Outlet";
parameter Real s2(unit"kJ/kgK")   = 7.0384 " Entropy of water at Point 2";
parameter Real s1(unit"kJ/kgK")   = 1.8418 " Enthalpy of water at Point 1";
parameter Real Cpo(unit"kJ/kgK")   = 1.09 " Specific heat of product of combustion";
parameter Real Ti(unit"K")   = 1373.15 " Temperature at Inlet of product";
parameter Real Te(unit"K")   = 823.15 " Temperature at Exit of product";

 equation
 
 //Ratio of mass flow rate of products to the mass flow rate of water
 Ratio1=(hew-hiw)/(Cpo*(hip-hep));
 
 //The increse in availability of water per kg of water
 psi21=(hew-hiw)-(To*(s2-s1));
 
 // Entropy change of product from 3 to 4
 seip=Cpo*log(Ti/Te);
 
 // The decreasein availability of products, per kg of water, is
 psi34=Ratio1*((Cpo*(hip-hep))-(To*(seip)));
 
 // Second law efficiency
 eta2ndlaw=psi21/psi34;
 
 // Process Irreversibiltiy per kg of water
 Idot=-psi21+psi34;
 
  /* The Process Irreversibility per kg of water is 906.406   kJ/kgH20 */
end Ex10_6;
