model Ex11_1
Real wp(unit="kJ/kg") "Work into the pump per kg of fluid flowing";
Real h2(unit="kJ/kg")   "Enthalpy at Boiler Inlet";
Real qH(unit="kJ/kg")   "Heat Transferred  to Boiler";
Real qL(unit="kJ/kg")   "Heat Rejected in Condenser";
Real etaT "Thermal Efficiency";
Real x4 "Quality of Steam at state 4";

parameter Real v(unit="m3/kg")    =0.00101 "Specific Volume";
parameter Real h1(unit="kJ/kg")   =191.8 "Enthalpy at inlet";
parameter Real h3(unit="kJ/kg")   =2799.5 "Enthalpy at Boiler Outlet";
parameter Real h4(unit="kJ/kg")   =2007.5 "Enthalpy at state 4";
parameter Real P2(unit="kPa")     =2000 "Boiler Pressure";
parameter Real P1(unit="kPa")     =10 "Condenser Pressure";
parameter Real s4(unit="kJ/kgK")  =6.3409 "Entropy at state 3 equal to state 4";
parameter Real s4f(unit="kJ/kgK") =0.6493 "Entropy of saturated liquid at sate 3/4";
parameter Real s4fg(unit="kJ/kgK")=7.5009 "Entropy at  Vaporization";

 equation
 
 //Calculation o fWork and enthalpy
 wp=v*(P2-P1);
 h2=h1+wp;
 
 // Energy Transferred
qH=h3-h2;

// Quality at State 4
x4=(s4-s4f)/s4fg;

// Energy Equation 
qL=h4-h1;

// Thermal Efficiency
etaT=(qH-qL)/qH;

/* Thermal Efficiency Obtained is 30.33% */

 

end Ex11_1;
