model Ex11_6

Real wc(unit="kJ/kg") "Compressor Work";
Real qL(unit="kJ/kg")   "Heat Transferred to Boiler";
Real Beta "Coefficient of Performance";

parameter Real etaT=0.86 "Tutbine Efficiency";
parameter Real etaP=0.80 "Pump Efficiency";
parameter Real v(unit="m3/kg")    =0.001009 "Specific Volume";
parameter Real h1(unit="kJ/kg")   =386.1 "Enthalpy  of R-134a at state 1 from table at given temperature";
parameter Real s1(unit="kJ/kgK")  =1.7395 "Entropy of R-134a at state 1";
parameter Real h2(unit="kJ/kg")   =428.4 "Enthalpy at state 2 from table at given temperature";
parameter Real h4(unit="kJ/kg")   =256.5 "Enthalpy at state 4 =h3 from table at given temperature";

 equation
 
  // Compressor Work
 wc= h2-h1; 
 
 // Energy Transferred to Evaporator 
 qL=(h1-h4);

 //COP
 Beta=qL/wc;
end Ex11_6;
