model Ex13_1

/*Analysis of Gaseous Mixture: Mol, Mass Basis*/
// Basis 1 mole of Mixture

Real MCO2 "Mass of Carbon dioxide per kmol of Mixture";
Real MO2 "Mass of Oxygen per kmol of Mixture";
Real MN2 "Mass of Carbon dioxide per kmol of Mixture";
Real MCO "Mass of Carbon dioxide per kmol of Mixture";

Real PCO2 "Mass Percentage of Carbon dioxide ";
Real PO2  "Mass Percentage of Oxygen ";
Real PN2  "Mass Percentage of Nitrogen ";
Real PCO  "Mass Percentage of Carbon Mono-Oxide ";
Real TM"Total Mass of the Mixture";

parameter Real xCO2=0.12 "Mole fraction of Carbon di-Oxide";
parameter Real xO2=0.04 "Mole fraction of Oxygen";
parameter Real xN2=0.82 "Mole fraction of Nitrogen";
parameter Real xCO=0.02 "Mole fraction of Carbon Mono-Oxide";

parameter Real MMCO2=44 "Molecular Mass of Carbon di-Oxide";
parameter Real MMO2=32 "Molecular Mass of Oxygen";
parameter Real MMN2=28 "Molecular Mass of Nitrogen";
parameter Real MMCO=28 "Molecular Mass of Carbon Mono-Oxide";

equation
// Mass Per kmol of Mixture
MCO2 =(MMCO2)*(xCO2); 
MO2=MMO2*xO2; 
MN2=MMN2*xN2; 
MCO=MMCO*xCO ;

// Total mass of the Mixture
TM=MCO2+MO2+MN2+MCO;

// Analysis on Mass Percent
/*Multiplied by 100 for converting into percentage*/
PCO2=100*MCO2/TM;
PO2=100*MO2/TM;
PN2=100*MN2/TM;
PCO=100*MCO/TM;


end Ex13_1;
