model Ex14_1
Real P1(unit="kPa")"Sublimation Pressure of Water Vapor -60 C";

parameter Real P2(unit="kPa")=0.0129 " Sublimation Pressure at -40 C";
parameter Real T2(unit="K")=233.2 "Temperature -40";
parameter Real T1(unit="K")=213.2 "Temperature -60 C";
parameter Real hig(unit="kJ/kg")=2838.9"Latent Heat";
parameter Real R(unit="kJ/kgK")=0.46152 "Gas Constant";

equation
/*Clapeyron Equation*/
P2=P1*exp((hig/R)*((1/T1)-1/(T2)));

end Ex14_1;
