model Ex14_6


Real h11a(unit="kJ/kg")"From generalized Chart enthalpy Change at constant Temperature";
Real h22a(unit="kJ/kg")"From generalized Chart enthalpy Change at constant Temperature";
Real h21a(unit="kJ/kg")"From generalized Chart enthalpy Change at constant Temperature";
Real q(unit="kJ/kg")"Heat Transfer";
Real sPT1(unit="kJ/kgK")"From Fig D.3";
Real sPT2(unit="kJ/kgK") "From Fig D.3";
Real sPT21(unit="kJ/kgK") "Difference in Entropy Ideal ";
Real ds(unit="kJ/kgK") "Entropy Change: s2-s1";

/* Using Values from Table A.2 */
parameter Real P1(unit="MPa")=8 "Initial Pressure";
parameter Real T1(unit="K")=150 "Initial Temperature";
parameter Real T2(unit="K")=125 "Initial Temperature";
parameter Real Tc=126.2 "Critical Temperature";
parameter Real P2(unit="MPa")=0.5 "Final Pressure";
parameter Real Pr1=2.36 " Initial Reduced Pressure";
parameter Real Pr2=0.147 " Finial Reduced Pressure";
parameter Real Tr1=1.189 "Initial Reduced Temperature";
parameter Real Tr2=0.99"Final Reduced Temperature";
parameter Real Cpo(unit="kJ/kgK")=1.0416 "Gas Constant";
parameter Real R(unit="kJ/kgK")=0.2968 "Gas Constant";


equation
h11a=2.5*R*Tc;
h21a=Cpo*(T2-T1);
h22a=0.15*R*Tc;
q=-(h22a)+(h21a)+(h11a);
sPT1=1.6*R;
sPT2=0.1*R;
sPT21=(Cpo*log(T2/T1))-(R*log(P2/P1));
ds=-sPT2+sPT21+sPT1;

end Ex14_6;
