model Ex14_7
Real Rm(unit="kJ/kgK")"Mean Gas Constant";
Real Tcm(unit="K")"Mean Temperature";
Real Pcm(unit="MPa")"Mean Pressure";
Real ya"Mole Fraction";
Real yb"Mole Fraction";
Real vk"Specific Volume from Kay's rule";
Real vv"Specific Volume from Van der waal";
Real Trm"Pseudo Reduced Temperature";
Real Prm"Pseudo Reduced Pressure";
Real dvk"Percentage Deviation of Specific Volume kay's rule";
Real dvv"Percentage Deviation of Specific Volume Van der waal";
Real aA(unit="kPAm6/kg2")"Vaan der Waal Constant ";
Real bA(unit="m3/kg")"Vaan der Waal Constant";
Real aB(unit="kPAm6/kg2")"Vaan der Waal Constant";
Real bB(unit="m3/kg")"Vaan der Waal Constant";
Real am(unit="kPAm6/kg2")"Vaan der Waal Constant for Mixture ";
Real bm(unit="m3/kg")"Vaan der Waal Constant for Mixture ";


parameter Real ve(unit="m3/kg")=0.006757"Specific Volume from Experiment";
parameter Real T(unit="K")=310.94  "Initial  Temperature of the Mixture";
parameter Real P(unit="bar")=8619  "Initial Pressure of the Mixture";
parameter Real Zm=0.7  "Compressibility Factor";
parameter Real Pca(unit="MPa")=7.38 " Critical Pressure of Comp. A: CO2";
parameter Real Pcb(unit="MPa")=4.60 " Critical Pressure of Comp. B: Methane";
parameter Real Tca(unit="K")=304.1  " Crirtical Temperature of Comp. A";
parameter Real Tcb(unit="K")=190.4  " Crirtical Temperature of Comp. B";
parameter Real Ra(unit="kJ/kgK")=0.1889 "Gas Constant of Comp. A";
parameter Real Rb(unit="kJ/kgK")=0.5183 "Gas Constant of Comp. B";
parameter Real ca=0.8 "Mass Fraction of comp A";
parameter Real cb=0.2 "Mass Fraction of comp B";
parameter Real Ma=44.01 "Molecular Weight of comp A";
parameter Real Mb=16.043 "Molecular Weight of comp B";


equation
Rm=ca*Ra+cb*Rb;
ya=(ca/Ma)/((ca/Ma)+(cb/Mb));
yb=1-ya;

// For Kay's Rule
Tcm=(ya*Tca)+(yb*Tcb);
Pcm=(ya*Pca)+(yb*Pcb);
Trm=T/Tcm;
Prm=P/(1000*Pcm);/*Dividedby 1000 for unit balance*/
vk=Zm*Rm*T/(P);
dvk=((ve-vk)/ve)*100;

//For Van der waal's Equation
aA=(27*(Ra^2)*(Tca^2))/(64*Pca*1000);
aB=(27*(Rb^2)*(Tcb^2))/(64*Pcb*1000);
bA=Ra*Tca/(8*Pca*1000);
bB=Rb*Tcb/(8*Pcb*1000);
am=(ca*(sqrt(aA))+cb*(sqrt(aB)))^2;
bm=(ca*bA)+(cb*bB);
vv=0.006326;/*From Van der Waal Equation*/
dvv=((ve-vv)/ve)*100;


end Ex14_7;
