model Ex15_14

/*The combustion Equation
C2H4(g)+12O2+12(3.76)N2 ====> 2CO2+2H2O(g)+9O2+45.1N2
*/
/* For Reactants*/
Real SC2H4(unit="kJ/K")"Entropy of Ethene";
Real Sair(unit="kJ/K")"Entropy of air";
Real SR(unit="kJ/K")"Entropy of Reactants";

Real I(unit="kJ/kmol Ethylene")"Irreversibility";
Real Im(unit="kJ/kg")"Irreversibility per kg";


parameter Real sTEo(unit="kJ/kmol.K")=219.330"Standard Entropy for Ethene";
parameter Real sTO2o(unit="kJ/kmol.K")=205.147"Standard Entropy for Oxygen";
parameter Real sTN2o(unit="kJ/kmol.K")=191.610"Standard Entropy for Nitrogen";
parameter Real R(unit="kJ/kmol.K")=8.314"Gas Constant";
parameter Real yO2=0.21"Mole Fraction of Oxygen in air";
parameter Real yN2=0.79"Mole Fraction of Nitrogen in air";
parameter Real nC2H4=1,nO2r=12,nN2=45.1"Coefficeints of Reactants";

parameter Real P(unit="kPa")=200"Entering Pressure";
parameter Real Po(unit="kPa")=100"Standard Pressure";
parameter Real To(unit="K")=298.15"Standard Temperature";
parameter Real MWE=28.054"Molecular Mass of Ethene";


/*For Products*/
Real SCO2(unit="kJ/K")"Entropy of CO2";
Real SH2O(unit="kJ/K")"Entropy of H2O";
Real SO2(unit="kJ/K")"Entropy of Oxygen in Products";
Real SN2(unit="kJ/K")"Entropy of Nitrogenin Products";
Real SP(unit="kJ/K")"Entropy of Products";

parameter Real nCO2=2,nH2O=2,nO2p=9,nN2p=45.1"Coefficeints of Products";
parameter Real yN2p=0.7763"Mole Fraction of Nitrogen in Products",yO2p=0.1549"Mole Fraction of Oxygen in Products",yH2O=0.0344"Mole Fraction of Water in Products", yCO2=0.0344"Mole Fraction of Carbon Dioxide in Products";
parameter Real sTN2op(unit="kJ/kmol.K")=228.691"Standard Entropy for Nitrogen",sTO2op(unit="kJ/kmol.K")=244.135"Standard Entropy for Oxygen",sTCO2o(unit="kJ/kmol.K")=270.194"Standard Entropy for CO2",sTH2Oo(unit="kJ/kmol.K")=233.355"Standard Entropy for H2O";

equation

// Entropy of Reactants
Sair=nO2r*(sTO2o-(R*log(yO2*P/Po)))+nN2*(sTN2o-(R*log(yN2*P/Po)));
SC2H4=nC2H4*(sTEo-(R*log(P/Po)));
SR=Sair+SC2H4;

// Entropy of Products
SCO2=nCO2*(sTCO2o-(R*log(yCO2*P/Po)));
SH2O=nH2O*(sTH2Oo-(R*log(yH2O*P/Po)));
SO2=nO2p*(sTO2op-(R*log(yO2p*P/Po)));
SN2=nN2p*(sTN2op-(R*log(yN2p*P/Po)));
SP=SCO2+SH2O+SO2+SN2;

//Irreversibility
I=To*(SP-SR);
Im=I/MWE;

end Ex15_14;
