model Ex15_5
Real MS   "Moles of Sulfur per 100 kg of fuel";
Real MH2  "Mass of Hydrogen per 100 kg of fuel";
Real MC   "Mass of Carbon per 100 kg of fuel";
Real MO2   "Mass of Oxygen per 100 kg of fuel";
Real MN2  "Mass of Oxygen per 100 kg of fuel";
/*Real MAsh "Mass of Oxygen per 100 kg of fuel";*/
Real AFtheo(unit="kg air/kg fuel")" Theoretical Air Fuel Ratio Mass Basis";
Real AFtheoE(unit="kg air/kg fuel")" For 30% Excess air Theoretical Air Fuel Ratio Mass Basis";
parameter Real TM(unit="kg")=100"Total Mass of the Mixture";

parameter Real MPS =0.6 "Mass Percent Sulfur";
parameter Real MPC =79.2 "Mass Percent Carbon";
parameter Real MPN2=1.5 "Mass Percent Nitrogen";
parameter Real MPO2 =10 "Mass Percent Oxygen";
parameter Real MPH2 =5.7 "Mass Percent hydrogen";

parameter Real MMS=32 "Molecular Mass of Sulfur";
parameter Real MMO2=32 "Molecular Mass of Oxygen";
parameter Real MMN2=28 "Molecular Mass of Nitrogen";
parameter Real MMC=12 "Molecular Mass of Carbon";
parameter Real MMH2=2 "Molecular Mass of Hydrogen";
parameter Real MA=28.97"Average Molecular weight of air";
parameter Real CTN=7.73*3.76"Nitrogen in equation Theoretical";
parameter Real CTO=7.73"Oxygen in equation Theoretical";

equation
// Moles Per kg of Mixture
MS =(MPS)/(MMS); 
MO2=MPO2/MMO2; 
MN2=MPN2/MMN2; 
MC=MPC/MMC ;
MH2=MPH2/MMH2 ;

/*Combustion Equation
0.02S+0.02O2===>0.02SO2
2.85H2+1.42O2===>2.85H2O
6.60C+6.60O2===>6.60O2*/

AFtheo=(CTN+CTO)*MA/(TM);
AFtheoE=1.3*AFtheo;


end Ex15_5;
