model Ex15_9

/*The Chemical Reaction is

C2H4+3O2===>2CO2+2H2O(g)

First Law: Q+UR=UP*/

Real Q(unit="kJ")"Amount of Heat Transfer from the system";
Real hR(unit="kJ")"Enthalpy of Reactants";
Real hP(unit="kJ")"Enthalpy of Products";

parameter Real nCO2=2,nH2O=2,nO2=3,nCH4=4"Coefficeints of Products and Reactants";
parameter Real hfoCO2=-393522,dhCO2=12906,hfoH2O=-241826,dhH2O=10499,hfoO2=0,hfoCH4=52467 "Enthalpy of Formation of Products and Reactants";
parameter Real R(unit="kJ/kmolK")=8.3145"Gas Constant";
parameter Real To(unit="K")=298.2"Reactant Temperature";
parameter Real T(unit="K")=600" Product Temperature";

equation
hR=hfoCH4-(4*R*To);
hP=nCO2*(hfoCO2+dhCO2)+nH2O*(hfoH2O+dhH2O)-(4*R*T);
Q=hR-hP;

end Ex15_9;
