model Ex16_5
/*The Over all Process is
        C+O2===>0.5622CO2+0.4378CO+0.2189O2
*/


Real yCO2"Equilibrium Mole Fraction of CO2", yCO"Equilibrium Mole Fraction of CO", yO2"Equilibrium Mole Fraction of O2";

Real HR(unit="kJ")"Enthalpies of Reactants";
Real HP(unit="kJ")"Enthalpies of Products";

Real Qcv(unit="kJ/kmol C burned")"Heat Transferred for the Process";

parameter Real z=0.2189 "By Trial and Error process";
parameter Real a=0.5622"Coefficient of CO2", b=0.4378"COefficient of CO",c=0.2189"Coefficient of O2";

parameter Real hfoCO2(unit="kJ/kmol")=-393522"Standard Enthalpy of Formation of C2H4", hfoCO(unit="kJ/kmol")=-110527"Standard Enthalpy of Formation of H2O(G)",hfoO2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Oxygen",hfoC(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Carbon";

parameter Real dhoCO23000(unit="kJ/kmol")=152853"Differemce in enthalpy of H2 between 3000 Kand 298.15 K", dhoCO3000(unit="kJ/kmol")=93504"Differemce in enthalpy between 2000 Kand 298.15 K of H2O(G)",dhoO23000(unit="kJ/kmol")=98013"Differemce in enthalpy between 2000 Kand 298.15 K of Oxygen";

equation

// Equilibrium Fractions
yCO2=a/(1+z);
yCO=b/(1+z);
yO2=c/(1+z);

// Heat Transfer
HR=hfoC+hfoO2;
HP=(a*(hfoCO2+dhoCO23000))+(b*(hfoCO+dhoCO3000))+(c*(hfoO2+dhoO23000));
Qcv=HP-HR;

end Ex16_5;
