model Ex17_8

Real Py(unit="kPa")"Static Pressure downstream of normal shock";
Real Ty(unit="K")"Static Temperature downstream of normal shock ";
Real Poy(unit="kPa")"Stagnation Pressure downstream of normal shock";

parameter Real Mx=2.197"Mach No. Upstream of Normal Shock from Table A.13",My=0.547"Mach No. downstream of Normal Shock from Table A.13";
parameter Real rPyPx=5.46"Ratio of Staic pressure of Downstream and Upstream from Table A.13";
parameter Real rTyTx=1.854"Ratio of Staic Temperature of Downstream and Upstream from Table A.13";
parameter Real rPoyPox=0.630"Ratio of Stagnation pressure of Downstream and Upstream from Table A.13";

parameter Real Px(unit="kPa")=93.9"Staic pressure Upstream ";
parameter Real Tx(unit="K")=183.2"Staic Temperature Upstream ";
parameter Real Pox(unit="kPa")=1000"Stagnation pressure Upstream ";

equation
Py=rPyPx*Px;
Ty=rTyTx*Tx;
Poy=rPoyPox*Pox;

end Ex17_8;
