model Ex17_9

Real Py(unit="kPa")"Static Pressure downstream of normal shock";
Real Ty(unit="K")"Static Temperature downstream of normal shock ";
Real Poy(unit="kPa")"Stagnation Pressure downstream of normal shock";

Real Px(unit="kPa")"Static Pressure downstream of normal shock";
Real Tx(unit="K")"Static Temperature downstream of normal shock ";

Real TE(unit="K")"Exit plane Temperature from y to E";
Real PE(unit="kPa")"Exit plane Press ure from y to E";

parameter Real Mx=1.5"Mach No. Upstream of Normal Shock from Table A.13",My=0.547"Mach No. downstream of Normal Shock from Table A.13";

parameter Real rPxPox=0.2724"Ratio of Staic pressure and Stangnation Pressure of Upstream from Table A.12";
parameter Real rTxTox=0.6897"Ratio of Staic Temperature Stagnation Temperaturre of Upstream from Table A.13";

parameter Real rPyPx=2.4583"Ratio of Staic pressure of Downstream and Upstream from Table A.13";
parameter Real rTyTx=1.320"Ratio of Staic Temperature of Downstream and Upstream from Table A.13";
parameter Real rPoyPox=0.9298"Ratio of Stagnation pressure of Downstream and Upstream from Table A.13";


parameter Real Pox(unit="kPa")=1000"Stagnation pressure Upstream ";
parameter Real Tox(unit="kPa")=360"Stagnation pressure Upstream ";

parameter Real rPyPoy=0.7202,rTyToy=0.9105,ME=0.339,rPEPoE=0.9222,rTEToE=0.9771,rPEPoy=0.9222;

equation

Px=rPxPox*Pox;
Tx=rTxTox*Tox;

Py=rPyPx*Px;
Ty=rTyTx*Tx;
Poy=rPoyPox*Pox;

PE=rPEPoE*Poy;
TE=rTEToE*Tox;/*As Tox=Toy=ToE and PoE=Poy*/

end Ex17_9;
