
model Ex2_5
Real Pg(unit="kPa")"Gauge Pressure";
Real Patm(unit="kPa")"Atmospheric Pressure";
Real Pv(unit="kPa")"Absolute Pressure in Vessel";
 

parameter Real rho(unit="kg/m3")=13590"Density of Mercury", g(unit="m/s2")=9.8"Acceleration due to gravity",Ho(unit="m")=0.24"Height difference between two columns",H(unit="m")=0.75"Height of Mercury column";

equation
Pg=rho*g*Ho/1000;/*Divided by 1000 fro unit balance*/
Patm=rho*g*H/1000;/*Divided by 1000 fro unit balance*/

Pv=(Patm+Pg);

end Ex2_5;
