model Ex4_7

Real Qcond( unit = "W")"Heat Flow by conduction";
Real Qconv( unit = "W")"Heat Flow by convection";

  parameter Real k(unit = "W/mK")=1.4 "Thermal Conductivity";
  parameter Real T1(unit = "K") = 20 "Inside Room Temperature";
  parameter Real T2(unit = "K")=12.1 "Outside Glass Temperature";
  parameter Real T3(unit = "K")=-10 " Cold Ambient Temperature";
  parameter Real x(unit = "m")=0.005 "Thickness of Glass Pane";
  parameter Real h(unit = "W/m2K")=100 "Convective heat transfer coefficient";
  parameter Real A(unit = "m2")=0.5 "Total surface Area";  
    
equation
 /*Fourier's Law of Conduction*/
 Qcond=-k*A*div(T1-T2,x); /*negtive sign shows the direction of increasing distance with temperature*/
 
 /*Newton's Law of cooling fro convective heat transfer*/
  Qconv=h*A*(T2-T3);
end Ex4_7;
