model Ex5_5

Real m1liq( unit = "kg") "Mass of Liquid";
Real V(unit="m3")"Volume of Mixture";
Real m1vap(unit="kg") "Mass of Vapor";
Real U1(unit="kJ") "Internal Energy of Mixture";
Real U2(unit="kJ") "Internal Energy of Mixture at conditin 2";
Real m(unit="kg") "Mass of Mixture";
Real v2(unit= "m3/kg") "Specific Volume of Mixture";
Real Q12(unit = "kJ") "Heat Transfer for the Process";
  
  parameter Real Vliq( unit = "m3")= 0.05 "Volume of Liquid";
  parameter Real Vvap( unit = "m3")= 4.95 "Volume of Vapor";
  parameter Real vf(unit="m3/kg")=0.001043 "Specific Volume of Liquid";
  parameter Real vg(unit"m3/kg")= 1.6940 " Specific Volume of Vapor";
  parameter Real u1liq(unit=" kj/kg")=417.36 " Specific Internal Energy of liquid";
  parameter Real u1vap(unit=" kJ/kg")=2506.1 " Specific Internal Energy of vapor";
  parameter Real u2(unit=" kJ/kg")=2600.5 " Specific Internal Energy of Mixture at condition 2";
  /* Value of u is obtained from Table B.1.2 */
  
equation

m1liq=Vliq/vf;
m1vap=Vvap/vg;

U1=m1liq*u1liq+m1vap*u1vap;

m=m1liq+m1vap;

V=Vliq+Vvap;

v2=V/m;

U2=m*u2;

Q12=U2-U1; 

/*Answers are slightly different because of accuracy */
end Ex5_5;
