model Ex5_8

/* This problem shows the calculation of enthalpy thrugh various ways
1. Ideal Gas Tables
2. Empirical Equation from Table A.6 with variable specific heat
3. Assuming Constant Specific Heat*/

Real dhc(unit="kJ/kg") "Enthalpy change at constant spcific heat";
Real Cpo1(unit="kJ/kg.K")" Variable Specific Heat Specific Heat";
Real dh1(unit="kJ/kg") "Enthalpy change at variable spcific heat";

// PART A enthalpy
parameter Real dh(unit="kJ/kg")= 1267.0  "Enthalpy Change: h2-h1=1540.2 - 273.2";
parameter Real Cpo(unit="kJ/kg.K")= 0.922 " Constant Specific Heat";
parameter Real T1(unit="K")= 300 " Initial Temperatue of the system";
parameter Real T2(unit="K")= 1500 "Final Temperature of the system";


    
  equation
  // Part B
    dhc=Cpo*(T2-T1);
    
    // Part c
    Cpo1=0.88-0.0001*0.9+0.54*0.9^2-0.33*0.9^3;
    dh1=Cpo1*(T2-T1);


end Ex5_8;
