model Ex6_6


Real Wdotcv(unit = "kW") "Power output";

   /*Values of Enthalpies are take from Steam Tables at Given T and P As given below*/
   
  parameter Real hi( unit = "kJ/kg")= 3137.0 "Enthalpy of Steam at inlet";
  parameter Real he( unit = "kJ/kg")= 2675.5 "Enthalpy of Exit steam";
  parameter Real Qdotcv(unit ="kW")=-8.5 "Heat Transfer from the turbine";
  parameter Real g(unit= "m/s2")=9.8066 "Acceleration due to gravity";
 
  parameter Real Zi(unit = "m")=6 "Height at inlet";
  parameter Real Ze(unit = "m")=3 "Height at Exit";
  parameter Real Xe=1 "Dryness Fraction or Quality of Steam at exit";
  parameter Real mdoti(unit"kg/s")=1.5 "Mass flow rate at inlet";
  parameter Real mdote(unit"kg/s")=1.5 "Mass flow rate at exit";
  
  parameter Real Vi(unit = "m/s")= 50 "Velocity of Steam at Inlet";
  parameter Real Ve(unit = "m/s")= 100 "Velocity of Steam at Exit";  
    
equation
/*From the First law for open System*/
Wdotcv=Qdotcv+mdoti*(hi+(Vi^2/(2*1000))+g*Zi/1000)-mdote*(he+(Ve^2)/(2*1000)+g*Ze/1000);
/*Divided by thousand for unit balance*/

/*The power output comes out  to be 678.2 kW*/
 

end Ex6_6;
