model Ex7_4


Real etat "thermal efficiency";
Real etac "Carnot Efficiency ";
Real QLdot( unit = "kW") "Heat Released";
Real WCdot(unit="kW") "Work Obtained from Carnot Engine";
Real QLCdot(unit="kW") "Heat Released from Carnot Engine";

   
  parameter Real Wdot( unit = "kW")=450 "Obtained work";
  parameter Real QHdot( unit = "kW") =1000 "Heat Transfer Rate";
  parameter Real TL(unit="K")=300 "Sink Temperature";
  parameter Real TH(unit="K")=500+273 "Source Temperature";
     
equation
    
  QLdot=QHdot-Wdot "The energy equation for overall engines";
  etat=Wdot/QHdot "Thermal efficiency calculation";
  etac= 1-(TL/TH) "Carnot efficiency calculation";
  
  /*Newrates of work and Heat Rejection*/
  WCdot=etac*QHdot; 
  QLCdot=QHdot-WCdot;
  
 /*Efficiency calculated in book is wrong, it is coming out to be0.611 instead of 0.635*/
end Ex7_4;
