model Ex8_10

Real QdotH(unit="kW")"Energy Supplied Hot Reservoit";
Real QdotL(unit="kW")"Energy Supplied Cold Reservoir";
Real SdotHP(unit="W/K")"Entropy Generation Heat Pump";
Real SdotCV1(unit="W/K")"Entropy Generation Control Volume 1";
Real SdotCV2(unit="W/K")"Entropy Generation Control Volume 2";
Real Sdottot(unit="W/K")" Total Entropy Generation";
 
  parameter Real betaHP = 4 " COP ";
  parameter Real Wdot( unit = "kW")= 10 "Power Input";
  parameter Real Thigh( unit = "K")= 323 "High Temperature of the cycle";  
  parameter Real Tlow(unit = "K")= 263 "Low Temperature of the cycle";
  parameter Real TL(unit = "K")= 281 "Cold Side Temperature";
  parameter Real TH(unit = "K")= 294 "Hot Side Temperature";
    
equation

QdotH=betaHP*Wdot;
QdotL=QdotH-Wdot;
SdotHP=(QdotH*1000/Thigh)-(QdotL*1000/Tlow); /*Multiplied by 1000 for converting kW to W*/
SdotCV1=(QdotL*1000/Tlow)-(QdotL*1000/TL);   /*Multiplied by 1000 for converting kW to W*/
SdotCV2=(QdotH*1000/TH)-(QdotH*1000/Thigh);  /*Multiplied by 1000 for converting kW to W*/

Sdottot=SdotCV1+SdotCV2+SdotHP;

end Ex8_10;
