model Ex8_4


Real ds(unit="kJ/kg.K") "Entropy Change: s2-s1";

parameter Real sT2o(unit="kJ/kg.K")= 8.0469 "Standard Entropy at 1500 K ";
parameter Real sT1o(unit="kJ/kg.K")= 6.4168 "Standard Entropy at 300 K";
parameter Real R(unit="kJ/kg.K")= 0.2598"Gas Constant forOxygen taken from A.5";
parameter Real P1(unit="kPa")= 200 " Final Pressure of the system";
parameter Real P2(unit="kPa")= 150 "Initaial Pressure of the system";
    
  equation
  // Using Relations for Ideal Gas Behavior
   ds=sT2o-sT1o-R*log(P2/P1);
    
end Ex8_4;
