model Ex9_1

Real w(unit="kJ/kg") "Work per kg of Steam";
Real he(unit="kJ/kg") "Enthalpy of Mixture";
Real xe"Dryness Fraction of leaving stream";


parameter Real hi(unit="kJ/kg")= 3051.2 "Enthalpy found from Steam Tables";
parameter Real si(unit="kJ/kg.K")= 7.1228 "Entropy found from steam Tables";
parameter Real Pe(unit="Mpa")= 0.15"Final Pressure";
parameter Real Se(unit="kJ/kg.K")= 7.1228 " Final Entropy of the Mixture: se=si";
parameter Real Sf(unit="kJ/kg.K")= 1.4335 "Entropy of saturated liquid";
parameter Real Sfg(unit="kJ/kg.K")= 5.7897 "Entropyof Saturated Vapor";
parameter Real hf(unit="kJ/kg")= 467.1 "Enthalpy of saturated liquid";
parameter Real hfg(unit="kJ/kg")= 2226.5 "Enthalpy of Saturated Vapor";
parameter Real Vi(unit="m/s")= 50 "Velocity at Inlet";
parameter Real Ve(unit="m/s")= 200 " Velocity at Exit";

   
  equation
   xe=(Se-Sf)/Sfg;
   he=hf+xe*hfg;
   w=hi+((Vi^2)/(2*1000))-he-((Ve^2)/(2*1000));
end Ex9_1;
