model Ex9_10
Real xes "Quality of Steam ";
Real xe "Quality of Steam at outlet conditions considering Real Process  ";
Real ws(unit="kJ/Kg")"Work Done in Ideal ISentropic Process";
Real he(unit="kJ/kg")"Enthalpy of Mixture at Outlet for Real Process";

Real hes(unit="kJ/kg") "Enthalpy of Mixture at Outlet";
Real eta "Efficiency of Turbine";

/*Values of Entropy and Enthalpy of different straems are calculated from B.1.3 and B.a.2*/
parameter Real si(unit="kJ/kgK")= 7.1228 "Entropy at State 1";
parameter Real hi(unit="kJ/kg")= 3051.2 "Enthalpy at inlet";

parameter Real hesf(unit="kJ/kg")= 225.9 "Enthalpy of saturated liquid at outlet";
parameter Real hesfg(unit="kJ/kg")= 2373.1 "Enthalpy  of saturated Vapoor at Outlet";

parameter Real ses(unit="kJ/kgK")= 7.1228 "Entropy of Mixture at Outlet";
parameter Real sesf(unit="kJ/kgK")= 0.7548 "Entropy of Saturated Liquid";
parameter Real sesfg(unit="kJ/kgK")= 7.2536 "Entropy of Saturated Vapor";
parameter Real wa(unit="kJ/kg")=600 "Work done in Real Process";
parameter Real hef(unit="kJ/kg")= 225.9 "Enthalpy of saturated liquid at Outlet for Real Process";
parameter Real hefg(unit="kJ/kg")=2373.1 "Enthalpy of saturated Vapor at Outlet for Real Process";
 
  equation
 xes=(ses-sesf)/(sesfg) ;
 hes=hesf+xes*hesfg;
 ws=hi-hes;
 eta=wa/ws;
 he=hi-wa;
 xe=(he-hef)/(hefg);
end Ex9_10;
