model Ex9_12

Real Tes(unit="K")"Temperatureat Exit Isentropic";
Real Te(unit="K")"Temperatureat Exit ";
Real ws(unit="kJ/kg")"Work done for Isentropic Process";
Real w(unit="kJ/kg")"Work done for Real Processc";

/*Values of Entropy and Enthalpy of different straems are calculated from B.1.3 and B.a.2*/
parameter Real k= 0.286 "Index for Polytropic Process";
parameter Real Pe(unit="kPa")= 150 "Exit Pressure";
parameter Real Pi(unit="kPa")= 100 "Inlet Pressure";
parameter Real Ti(unit="K")= 300 "Inlet Temperature";
parameter Real Cpo(unit="kJ/kgK")= 1.004 "Specific Heat";/* From Table A.5*/
parameter Real eta=0.70 "Efficiency of Turbine";

  equation
 Tes=Ti*(Pe/Pi)^k ;/*from the second law*/
 ws=Cpo*(Ti-Tes);/*From First Law for isentropic process*/
 w=ws/eta;/**Real Work Input*/
Te= Ti-div(w,Cpo);
end Ex9_12;
