model Ex10_7
Real Eflux1(unit="kJ/kg") "energy Flux 1";
Real Eflux2(unit="kJ/kg") "energy Flux 1";
Real psii(unit="kJ/kgH2O") "Flow exergy at inlet";
Real psie(unit="kJ/kgH2O") "Flow exery at outlet ";
Real Idotcv(unit="kJ/kg") "The destruction of exergy";
Real eta2ndlaw " Second Law Efficiency of Heater";

parameter Real To(unit="K")=298.2 "Standard Temperature";
parameter Real ho(unit"kJ/kg")    = 104.87" Standard Enthalpy";
parameter Real so(unit"kJ/kg")    = 0.3673 " Standard Entropy";
parameter Real htoti(unit"kJ/kg")   = 171.97 " Total Enthalpy at Inlet";
parameter Real htote(unit"kJ/kg")   = 765.25 " Total Enthalpy at Outlet";
parameter Real si(unit"kJ/kgK")   = 0.5705 " Entropy at Inlet";
parameter Real se(unit"kJ/kgK")   = 2.1341 " Entropy at outlet";
parameter Real q1(unit"kJ/kg")   = 180 " Heat Flow at Point 1";
parameter Real q2(unit"kJ/kg")   = 413.28 " Heat Flow at Point 2";
parameter Real T1(unit"K")   = 373.2 " Temperature at Inlet of product";
parameter Real T2(unit"K")   = 473.2 " Temperature at Exit of product";

 equation
 
 //Calculationsof Flow Exergy
 psii=htoti-ho-To*(si-so);
 psie=htote-ho-To*(se-so);
 
 //Exergy Fluxes fromheat Transfer
 Eflux1=(1-(To/T1))*q1;
 Eflux2=(1-(To/T2))*q2;
 
 // he destruction of exergy 
 Idotcv=Eflux1+Eflux2+psii-psie;
 
// Second law efficiency
 eta2ndlaw=(Eflux1+Eflux2-Idotcv)/(Eflux1+Eflux2);
 

end Ex10_7;
