model Ex11_2
Real wp(unit="kJ/kg") "Work into the pump per kg of fluid flowing";
Real wt(unit="kJ/kg") "Turbine Work";
Real wnet(unit="kJ/kg") "Net Work";
Real h2(unit="kJ/kg")   "Enthalpy at Boiler Inlet";
Real h4(unit="kJ/kg")   "Enthalpy at state 4";
Real qH(unit="kJ/kg")   "Heat Transferred  High Temperature Reservoir";
Real etaT "Thermal Efficiency";
Real x4 "Quality of Steam at state 4";

parameter Real v(unit="m3/kg")    =0.00101 "Specific Volume";
parameter Real h1(unit="kJ/kg")   =191.8 "Enthalpy at inlet";
parameter Real h3(unit="kJ/kg")   =3213.6 "Enthalpy at state 3 ";
parameter Real P2(unit="kPa")     =4000 "Boiler Pressure";
parameter Real P1(unit="kPa")     =10 "Condenser Pressure";
parameter Real s4(unit="kJ/kgK")  =6.7690 "Entropy at state 3 equal to state 4";
parameter Real s4f(unit="kJ/kgK") =0.6493 "Entropy of saturated liquid at sate 3/4";
parameter Real s4fg(unit="kJ/kgK")=7.5009 "Entropy at Vaporization";
parameter Real h4f(unit="kJ/kg")  =191.8 "Enthalpy of saturated liquid at sate 3/4";
parameter Real h4fg(unit="kJ/kg") =2392.8 "Enthalpy of Vaporization";

 equation
 
 //Calculation of Work and enthalpy
 wp=v*(P2-P1);
 h2=h1+wp;
 
 // Quality at State 4
 x4=(s4-s4f)/s4fg;
 h4=h4f+(x4*h4fg);
 
 // Turbine Work
 wt=h3-h4;
 
 // Net Work
 wnet=wt-wp;
 
 // Energy Transferred to Boiler 
 qH=h3-h2;

//Thermal Efficiency
 etaT=wnet/qH;
 
 /* Thermal Efficiency obtained 35.3% */
end Ex11_2;
