model Ex11_3
Real wp(unit="kJ/kg") "Work into the pump per kg of fluid flowing";
Real wt(unit="kJ/kg") "Turbine Work";
Real wnet(unit="kJ/kg") "Net Work";
Real h2(unit="kJ/kg")   "Enthalpy at Boiler Inlet";
Real h4(unit="kJ/kg")   "Enthalpy at state 4";
Real h6(unit="kJ/kg")   "Enthalpy at state 6";
Real qH(unit="kJ/kg")   "Heat Transferred  High Temperature Reservoir";
Real etaT "Thermal Efficiency";
Real x4 "Quality of Steam at state 4";
Real x6 "Quality of Steam at state 6";

parameter Real v(unit="m3/kg")    =0.00101 "Specific Volume";
parameter Real h1(unit="kJ/kg")   =191.8 "Enthalpy at inlet";
parameter Real h3(unit="kJ/kg")   =3213.6 "Enthalpy at state 3 ";
parameter Real P2(unit="kPa")     =4000 "Boiler Pressure";
parameter Real P1(unit="kPa")     =10 "Condenser Pressure";
parameter Real s4(unit="kJ/kgK")  =6.7690 "Entropy at state 3 equal to state 4";
parameter Real s4f(unit="kJ/kgK") =1.7766 "Entropy of saturated liquid at sate 3/4";
parameter Real s4fg(unit="kJ/kgK")=5.1193 "Entropy at Vaporization";
parameter Real h4f(unit="kJ/kg")  =604.7 "Enthalpy of saturated liquid at sate 3/4";
parameter Real h4fg(unit="kJ/kg") =2133.8 "Enthalpy of Vaporization";
parameter Real h5(unit="kJ/kg")   =3273.4 "Enthalpy at state 5 ";
parameter Real s6(unit="kJ/kgK")  =7.8985 "Entropy at state 5 equal to state 6";
parameter Real s6f(unit="kJ/kgK") =0.6493 "Entropy of saturated liquid at sate 5/6";
parameter Real s6fg(unit="kJ/kgK")=7.50009 "Entropy at Vaporization at state 6";
parameter Real h6f(unit="kJ/kg")  =191.8 "Enthalpy of saturated liquid at sate 5/6";
parameter Real h6fg(unit="kJ/kg") =2392.8 "Enthalpy of Vaporization";

 equation
 
 //Calculation of Work and enthalpy
 wp=v*(P2-P1);
 h2=h1+wp;
 
 // Quality at State 4
 x4=(s4-s4f)/s4fg;
 h4=h4f+(x4*h4fg);
 
 // Quality at state 6
 x6=(s6-s6f)/s6fg;
 h6=h6f+(x6*h6fg);
 
 // Turbine Work
 wt=(h3-h4)+(h5-h6);
 
 // Net Work
 wnet=wt-wp;
 
 // Energy Transferred to Boiler 
 qH=(h3-h2)+(h5-h4);

//Thermal Efficieny
etaT=wnet/qH;

/* Thermal Efficiency obtained is 35.85% */
end Ex11_3;
