model Ex12_4
/*Process: Reversible Isothermal */
Real wc(unit="kJ/kg") "Compressor Work: Work Input to Compressor";
Real wt(unit="kJ/kg") "Turbine Work";

parameter Real R(unit="kJ/kgK")=0.287 "Gas Constant";
parameter Real T1(unit="K")=288.2 "Inlet Air Temperature Compressor ";
parameter Real T3(unit="K")=1373.2 "Inlet Temperature Turbine ";
parameter Real P1(unit="MPa ")=0.1 "Inlet Air Pressure Compresssor";
parameter Real P2(unit="MPa ")=1 "Leaving Air Pressure Compressor";
parameter Real P3(unit="MPa ")=1 "Inlet Air Pressure Turbine";
parameter Real P4(unit="MPa ")=0.1 "Leaving Air Pressure Turbine";

equation
// Compressor Work
wc=-R*T1*log(P2/P1); /*Compared to -269.5 kJ/kg in the adiabatic compressor Isothermal work is -190.5 */

// Turbine Work
wt=-R*T3*log(P4/P3); /*Compared to +664.7 kJ/kg in the adiabatic compressor Isothermal work is 907.5 */
end Ex12_4;
