model Ex13_3

Real Pv(unit="kPa")"Partial Pressure of Vapor";
Real Pa(unit="kPa")"Partial Pressure of Air";
Real w"Humidity Ratio";
Real ma(unit="kg")"Mass of Air";
Real mv(unit="kg")"Mass of Vapor";

parameter Real  phi=0.70 "Relative Humidity";
parameter Real  Pg(unit="kPa")=5.68 "Vapor Pressure";
parameter Real  P(unit="kPa")=100 "Total Pressure";
parameter Real  V(unit="m3")=100 "Volume of Mixture";
parameter Real  Ra(unit="kJ/kgK")=0.287 "Gas Constant";
parameter Real  T(unit="K")=308.2 "Temperature";

equation

Pv=phi*Pg;
Pa=P-Pv;
w=0.622*(Pv/Pa);
ma=Pa*V/(Ra*T);
mv=w*ma;


end Ex13_3;
