model Ex13_5

Real Pv1(unit="kPa")"Partial Pressure of Vapor at Inlet";
Real Pv2(unit="kPa")"Partial Pressure of Vapor at Outlet";
Real Pa1(unit="kPa")"Partial Pressure of Air at Inlet";
Real Pa2(unit="kPa")"Partial Pressure of Air at Outlet";
Real w1"Humidity Ratio at Inlet"; 
Real w2"Humidity Ratio at Outlet"; 
Real Qdotcv(unit="kJ/kg dry air")"Heat Transfer per kg of dry air";

parameter Real  phi1=0.80 "Relative Humidity at Inlet";
parameter Real  phi2=0.95 "Relative Humidity at Outlet";
parameter Real  Pg1(unit="kPa")=4.246 "Vapor Pressure at Inlet";
parameter Real  Pg2(unit="kPa")=1.7051 "Vapor Pressure at Outlet";
parameter Real  P1(unit="kPa")=105 "Total Pressure at Inlet";
parameter Real  P2(unit="kPa")=100 "Total Pressure at Outlet";
parameter Real  T1(unit="K")=30+273.15 "Temperature at Inlet";
parameter Real  T2(unit="K")=15+273.15 "Temperature at Inlet";
parameter Real  Cp(unit="kJ/kgK")=1.004"Specific Heat of Air";
parameter Real  hl2(unit="kJ/kg")=62.99 "Enthalpy pf liquid at outlet";
parameter Real  hv2(unit="kJ/kg")=2528.9 "Enthalpy pf Vapor at outlet";
parameter Real  hv1(unit="kJ/kg")=2556.3 "Enthalpy pf Vapor at Inlet";

equation

Pv1=phi1*Pg1;
Pa1=P1-Pv1;
w1=0.622*(Pv1/Pa1);
Pv2=phi2*Pg2;
Pa2=P2-Pv2;
w2=0.622*(Pv2/Pa2);

Qdotcv=(Cp*(T2-T1))+(w2*hv2)+((w1-w2)*hl2)-(w1*hv1);

end Ex13_5;
