model Ex13_7
Real w2"Humidity Ratio at 2";
Real w1"Humidity Ratio at 1";
Real Pv1(unit="kPa")"Partial Pressureof Vapor at Entrance";
Real phi1"Realative Humidity at Entrance";


parameter Real  Pv2(unit="kPa")=2.339 "Partial Pressure of vapor at Exit";
parameter Real  Pg2(unit="kPa")=2.34 "Partial Pressure of air at Exit";
parameter Real  Pg1(unit="kPa")=4.246 "Partial Pressure of air at inlet";
parameter Real  P(unit="kPa")=100 "Total Pressure";
parameter Real  V(unit="m3")=0.5 "Volume of Tank";
parameter Real  RN(unit="kPa")=0.2968 "Value of  Gas Constant for Nitrogen ";
parameter Real  RV(unit="kPa")=0.4615 "Value of  Gas Constant for Water Vapor ";
parameter Real  P1(unit="kPa")=105 "Total Pressure at Inlet";
parameter Real  P2(unit="kPa")=100 "Total Pressure at Outlet";
parameter Real  T1(unit="K")=30+273.15 " Initial Temperature";
parameter Real  T2(unit="K")=20+273.15 " Final Vapor Temperature";
parameter Real  Cpa(unit="kJ/kgK")=1.004"Specific Heat of Air";
parameter Real  hl2(unit="kJ/kg")=83.96 "Enthalpy of liquid ";
parameter Real  hv1(unit="kJ/kg")=2556.3 "Enthalpy of Vapor ";
parameter Real  hfg2(unit="kJ/kg")=2454.1 "Enthalpy of Vaporization";


equation

w2=0.622*(Pv2/(P-Pg2));
w1=((Cpa*(T2-T1))+(w2*hfg2))/(hv1-hl2);
Pv1=(w1*100)/(0.622*1.0172);
phi1=Pv1/Pg1;
end Ex13_7;
