model Ex14_4

Real w(unit="J/kg")"Isothermal Work";
Real ds(unit="J/kgK")" s2-s1: Entropy Change";
Real du(unit="J/kg")" u2-u1: Internal Energy Change";
Real q(unit="J/kg")"Heat Transfer for Reversible Isothermal Process";

parameter Real alphaP(unit="1/K")=5.0*10^(-5) " Volume Expansivity";
parameter Real BetaT(unit="m2/N")=8.6*10^(-12) "Isothermal COmpressibility";
parameter Real v(unit="m3/kg")=0.000114 "Specific Volume";
parameter Real P2(unit="kPa")=100 "Final Pressure";
parameter Real P1(unit="kPa")=0.1 "Initial Pressure";
parameter Real T(unit="K")=288.2 "Temperature";

equation

w=-v*BetaT*((P2^2)-(P1^2))*(10^12)/2;
ds=-v*alphaP*(P2-P1)*10^6;
q=T*ds;
du=q-w;


end Ex14_4;
