model Ex15_10

/*calculations of Enthalpy of combustions from enthalpiesf formation*/
/*The Basic Combuston Equation is
C3H8+5O2===>3CO2+4H2O
*/

/*Part 1 Liquid Propane- Liquid Water*/
Real hRP1mol(unit="kJ/kmol")"Enthalpy of comustion of propane Mass Basis: Liquid Propane- Liquid Water";
Real hRP1mass(unit="kJ/kg")"Enthalpy of comustion of propane mol Basis: Liquid Propane- Liquid Water";

/*Part 2 Liquid Propane- Gaseous Water*/
Real hRP2mol(unit="kJ/kmol")"Enthalpy of comustion of propane Mass Basis Part 2: Liquid Propane- Gaseous Water";
Real hRP2mass(unit="kJ/kg")"Enthalpy of comustion of propane mol Basis Part 2: Liquid Propane- Gaseous Water";

/*Part 3 Gaseous Propane- Liquid Water*/
Real hRP3mol(unit="kJ/kmol")"Enthalpy of comustion of propane Mass Basis Part 3: Gaseous Propane- Liquid Water";
Real hRP3mass(unit="kJ/kg")"Enthalpy of comustion of propane mol Basis Part 3: Gaseous Propane- Liquid Water";

/*Part 4 Gaseous Propane- Gaseous Water*/
Real hRP4mol(unit="kJ/kmol")"Enthalpy of comustion of propane Mass Basis Part 4: Gaseous Propane- Gaseous Water";
Real hRP4mass(unit="kJ/kg")"Enthalpy of comustion of propane mol Basis Part 4: Gaseous Propane- Gaseous Water";

parameter Real hfoCO2(unit="kJ/kmol")=-393522"Standard Enthalpy of Formation of CO2", hfoH2Ol(unit="kJ/kmol")=-285830"Standard Enthalpy of Formation of H2O(L)",hfoH2Og(unit="kJ/kmol")=-241826"Standard Enthalpy of Formation of H2O(G)",hfoC3H8l(unit="kJ/kmol")=-120216"Standard Enthalpy of Formation of Propane(L)",hfoC3H8g(unit="kJ/kmol")=-103900"Standard Enthalpy of Formation of Propane(G)";

parameter Real nCO2=3,nH2O=4,nC3H8=1"Coefficeints of Products and Reactants";
parameter Real MWP=44.097"Molecular wt of Propane";

equation
// Part 1 Liquid Propane- Liquid Water
hRP1mol=nCO2*hfoCO2+nH2O*hfoH2Ol-nC3H8*hfoC3H8l;
hRP1mass=hRP1mol/MWP;

// Part 2 Liquid Propane- Gaseous Water
hRP2mol=nCO2*hfoCO2+nH2O*hfoH2Og-nC3H8*hfoC3H8l;
hRP2mass=hRP2mol/MWP;

// Part 3 Gaseous Propane- Liquid Water
hRP3mol=nCO2*hfoCO2+nH2O*hfoH2Ol-nC3H8*hfoC3H8g;
hRP3mass=hRP3mol/MWP;

// Part 4: Gaseous Propane- Gaseous Water
hRP4mol=nCO2*hfoCO2+nH2O*hfoH2Og-nC3H8*hfoC3H8g;
hRP4mass=hRP4mol/MWP;
 
end Ex15_10;
