model Ex15_13

Real dHo(unit="kJ/kmol Fuel")"Standard Enthalpy change involved";
Real dSo(unit="kJ/kmol Fuel")"Standard Entropy change involved";
Real dGo(unit="kJ/kmol C2H4")"Standard Gibbs Free change involved";
Real Wrev(unit="kJ/kmol C2H4")"Reversible Work";
Real Wrevm(unit="kJ/kg")"Reversible Work: per kg";

parameter Real hfoC2H4g(unit="kJ/kmol")=52467"Standard Enthalpy of Formation of C2H4", hfoH2Og(unit="kJ/kmol")=-241826"Standard Enthalpy of Formation of H2O(G)",hfoCO2(unit="kJ/kmol")=-393522"Standard Enthalpy of Formation of CO2",hfoO2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Oxygen";

parameter Real sfoC2H4g(unit="kJ/kmol")=219.330"Standard Entropy of Formation of C2H4", sfoH2Og(unit="kJ/kmol")=188.843"Standard Entropy of Formation of H2O(G)",sfoCO2(unit="kJ/kmol")=213.795"Standard Entropy of Formation of CO2",sfoO2(unit="kJ/kmol")=205.148"Standard Entropy of Formation of Oxygen";

parameter Real nCO2=2,nH2O=2,nO2=3,nC2H4=1"Coefficeints of Products and Reactants";
parameter Real To(unit="K")=298.15"Standard Temperature";
parameter Real MWE(unit="K")=28.054"Molecular Weight of Ethene";

equation
dHo=(nCO2*hfoCO2)-(nO2*hfoO2)-(nC2H4*hfoC2H4g)+(nH2O*hfoH2Og);
dSo=(nCO2*sfoCO2)-(nO2*sfoO2)-(nC2H4*sfoC2H4g)+(nH2O*sfoH2Og);
dGo=dHo-(To*dSo);
Wrev=-(dGo);
Wrevm=Wrev/MWE;

end Ex15_13;
