model Ex15_15
Real dHo(unit="kJ/kmol Fuel")"Standard Enthalpy change involved";
Real dSo(unit="kJ/kmol Fuel")"Standard Entropy change involved";
Real dGo(unit="kJ/kmol C2H4")"Standard Gibbs Free change involved";
Real zetao(unit="V")"Maximum Electrical Potential";

parameter Real hfoH2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Hydrogen", hfoH2O(unit="kJ/kmol")=-285830"Standard Enthalpy of Formation of H2O(l)",hfoO2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Oxygen";

parameter Real sfoH2O(unit="kJ/kmol")=69.950"Standard Entropy of Formation of H2O(l)",sfoH2(unit="kJ/kmol")=130.678"Standard Entropy of Formation of Hydrogen",sfoO2(unit="kJ/kmol")=205.148"Standard Entropy of Formation of Oxygen";

parameter Real nH2=2,nH2O=2,nO2=1"Coefficeints of Products and Reactants";
parameter Real ne=4"No. of Electrons";
parameter Real To(unit="K")=298.15"Standard Temperature";

equation
dHo=-(nH2*hfoH2)-(nO2*hfoO2)+(nH2O*hfoH2O);
dSo=-(nH2*sfoH2)-(nO2*sfoO2)+(nH2O*sfoH2O);
dGo=dHo-(To*dSo);
zetao=-(dGo)/(96485*ne);
end Ex15_15;
