model Ex15_16
/* First Law for Control Volume:
   HR+KER=HP+KEP
      
   First we will calculate kmol of oxygen per kmol of fuel
*/

parameter Real hfoC8H18(unit="kJ/kmol")=-250105"Standard Enthalpy of Formation of C8H18", hfoH2O(unit="kJ/kmol")=-241826"Standard Enthalpy of Formation of H2O(G)",hfoCO2(unit="kJ/kmol")=-393522"Standard Enthalpy of Formation of CO2",hfoO2(unit="kJ/kmol")=0"Standard Enthalpy of Formation of Oxygen";

parameter Real dhO2(unit="kJ/kmol")=3034"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Oxygen",dhCO2(unit="kJ/kmol")=38891"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Carbon dioxide",dhH2O(unit="kJ/kmol")=30147"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Hydrogen",dhN2(unit="kJ/kmol")=2971"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Nitrogen",dhO2p(unit="kJ/kmol")=26218"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Oxygen",dhN2p(unit="kJ/kmol")=24758"Difference in enthalpy brtween given state and the enthalpy of ideal gas for Nitrogen";

parameter Real nCO2=8,nH2O=9"Coefficeints ";

parameter Real MMOct=114.23"Molecular Mass of Octane", MMO2=32"Molecular Mass of Oxygen", MMN2=28.02"Molecular Mass of Nitrogen", MMCO2=44.01"Molecular Mass of CO2", MMH2O=18.02"Molecular Mass of Water",MMair=28.97"Molecular Mass of Air";

parameter Real Cpo(unit="kJ/kmolK")=2.23*MMOct"Specific Heat of Octane";

parameter Real T0(unit="K")=298.15"Standard Temperature";
parameter Real T1(unit="K")=50+273.15"C8H18 Temperature";
parameter Real Vair(unit="m/s")=100"Velocity of air";
parameter Real Vp(unit="m/s")=150"Velocity of Products";

Real HRC8H18"first Term of Equaion: Enthalpy and K.E Of C8H18";
Real HRO2N2"2nd and 3rd  Term of Equaion: Enthalpy and K.E Of O2 and N2 Respectively";
Real HPCO2H2O"RHS 1st,2nd and 3rd(w/o nO2) Term of Equaion: Enthalpy and CO2,H2Oand O2 in Products ";
Real HPnO2"RHS 4th and 5th  Term of Equaion: Enthalpy and K.E Of O2 and N2in Product Respectively";
Real CnO2"Coeffient of nO2 obtained from above equation";
Real S"Equating LHS and RHS of Equation, term containig no nO2 or simply integer value";
Real nO2"kmol O2/kmol fuel";
Real nO2m"mass basis";
Real FAideal"Ideal AIr Fuel Ratio";
Real FAact"Actual Air Fuel Ratio";
Real etaComb"Comustion Efficiency";

equation
HRC8H18=hfoC8H18+Cpo*(T1-T0);
HPnO2=(dhO2+((MMO2*Vair^2)/(2*1000)))+(3.76*(dhN2+((MMN2*Vair^2))/(2*1000)));
HPCO2H2O=nCO2*(hfoCO2+(dhCO2+((MMCO2*Vp^2)/(2*1000))))+(nH2O*(hfoH2O+(dhH2O+((MMH2O*Vp^2)/(2*1000)))))-(12.5*((dhO2p+((MMO2*Vp^2)/(2*1000)))));
HRO2N2=(((dhO2p+((MMO2*Vp^2)/(2*1000)))))+(3.7*((dhN2p+((MMN2*Vp^2)/(2*1000)))));

CnO2=HRO2N2-HPnO2;
S=HRC8H18-HPCO2H2O;
nO2=S/CnO2;
nO2m=nO2*4.76;

//Ideal Air Fuel Ratio
FAideal=MMOct/(nO2m*MMair);

//Actual Air Fuel Ratio
FAact=0.0211;

// Comustion Efficiency
etaComb=(FAideal/FAact)*100;

/* Answer is Slightly vary because of higher accuracy */

end Ex15_16;
