model Ex17_4

Real Pes(unit="kPa")"Exit Pressure of  Reversible Diffuser";
Real dhei(unit="kJ/kg")"Enthalpy change around actual diffuser";
Real duei(unit="kJ/kg")"Internal Energy change around actual diffuser";
Real dsei(unit="kJ/kgK")"Entropy change around actual diffuser";

parameter Real Pi(unit="kPa")=350"Inlet Water Pressure in Pump Casing";
parameter Real Pe(unit="kPa")=600"Exit  Pressure ";
parameter Real Ve(unit="m/s")=7"Exit Velocity ";
parameter Real Vi(unit="m/s")=30"Inlet Velocity ";
parameter Real T(unit="K")=298.2"Inlet Temperature ";
parameter Real v(unit="m3/kg")=0.001003"Specific Volume found from Steam Tables ";


equation
// Exit Pressure
Pes=(Vi^2-Ve^2)/(2*v*1000)+(Pi);

// Increase in Enthalpy
dhei=(Vi^2-Ve^2)/(2*1000);

//Increase in Internal Energy
duei=dhei-(v*(Pe-Pi));

//Increase in Entropy
dsei=duei/T; /* *Incompressible Fluid =>dv=0 */


end Ex17_4;
