model Ex2_3

Real Acyl(unit="m2")"Area of Cylinder";
Real Arod(unit="m2")"Area of Rod";
Real F(unit="N")" Force ";

parameter Real Dc(unit="m")=0.1  "Diameter of Cylinder";
parameter Real Dr(unit="m")=0.01 "Diameter of Rod";

parameter Real mp(unit="kg")=25"Mass of Piston";
parameter Real g(unit="m/s2")=9.81"Acceleration due to gravity";

parameter Real Po(unit="kPa")=101 "Outside Atmospheric Pressure";
parameter Real Pcyl(unit="kg/m3")=250 "Inside hydraulicfluid pressure";
final constant Real pi=2*Modelica.Math.asin(1.0);

equation

Acyl=(pi/4)*Dc^2;
Arod=(pi/4)*Dr^2;

F=((Pcyl*Acyl)-(Po*(Acyl-Arod)))*1000-(mp*g);/*Multiplied by 1000 to convert kPa to Pa for getting unit N*/


end Ex2_3;
