model Ex2_7
Real P1(unit="kPa")"Fluid Pressure";
Real P2(unit="kPa")"Pressure at Higher Elevation";
Real F2(unit="kN")"Balancing Force on 2nd Piston";


parameter Real Po(unit="kPa")=100"Outside Atmospheric Pressure";
parameter Real F1(unit="kN")=25"Net Force on Small Piston";
parameter Real A1(unit="m2")=0.01"Cross-Sectional Area of Piston of Piston 1";
parameter Real A2(unit="m2")=0.05"Cross-Sectional Area of Piston of Piston 2";
parameter Real g(unit="m/s2")=9.81"Acceleration due to gravity";
parameter Real H(unit="m")=6"Height of 2nd Piston";
parameter Real rho(unit="kg/m3")=900"Fluid Density";

equation
P1=Po+(F1/A1);
P2=P1-(rho*g*H/1000);/* Divided by 1000 to convert Pa to kPa*/
F2=(P2-Po)*A2;

end Ex2_7;
