model Ex3_13

Real Tr "Reduced Temperature";
Real Z  "Overall Compressibity Factor";
Real m(unit="kg")  " Mass of Propane";
Real P(unit="kPa") "Pressure";
Real N "Product of P*V to make calculation easier";
Real D "Denominator term which implies product of Z*R*T for calculation of m";

 
  parameter Real Pc(unit = "kPa") = 4250 " Critical Pressure";
  parameter Real Tc(unit = "K") = 369.8 "Critical Temperature";
  parameter Real Zf  =  0.035 ;
  parameter Real Zg = 0.83 ;
  parameter Real PrSat = 0.2 " Saturated Pressure at reduced state";
  parameter Real x = 0.1"Dryness Fraction" ;
  parameter Real V(unit = "m3")=0.1 "Volume";
  parameter Real R(unit = "kJ/kgK") =0.1886 "From Gas constant table";
  parameter Real T(unit = "K") = 288.15 "Given in Question";
  
equation
   
  Tr=T/Tc;
  P=PrSat*Pc;
  Z=(1-x)*Zf+x*Zg;
  N=(P*V);
  D=(Z*R*T);
    m= N/D;

end Ex3_13;
