model Ex6_13

Real x2 "Dryness Fraction at condition 2";
Real mf1(unit = "kg") "Mass of Saturated liquid";
Real mg1(unit="kg") "Mass of saturated vapor";
Real m1(unit = "kg") "Total Mass of Mixture at initial conditions";
Real m2(unit = "kg") "Total Mass of Mixture at conditions 2";
Real me(unit = "kg") "Mass of Ammonia withdrawn";
Real u1(unit = "kJ/kg") "Total internal energy of Mixture";
Real u2(unit = "kJ/kg") "Total internal energy of Mixture at condition 2";
Real v2(unit = "m3/kg") "Total Specific volume of Mixture at condition 2";

/*the follwing values are obtained from the ammonia tables*/
parameter Real vf1( unit = "m3/kg")= 0.001725 "Specific Volume of saturated liquid at initial conditions";
parameter Real vg1( unit = "m3/kg")= 0.08313 "Specific volume of saturated vapor at initial conditions";
parameter Real vf2( unit = "m3/kg")= 0.00160  "Specific Volume of saturated liquid at exit";
parameter Real vfg2( unit = "m3/kg")= 0.20381 "Specific volume of vaporization at exit";
parameter Real uf1( unit = "kJ/kg")= 368.7 "Internal Energy of saturated liquid at initial conditions";
parameter Real ug1( unit = "kJ/kg")= 1341.0 "Internal Energy of saturated vapor at initial conditions";
parameter Real uf2( unit = "kJ/kg")= 226  "Internal Energy of liquid at exit";
parameter Real ufg2( unit = "kJ/kg")= 1099.7 "Internal Energy of vaporizatin at exit";

   /*Values of Enthalpies are take from Steam Tables at Given T and P As given below*/
   
  
  parameter Real he( unit = "kJ/kg")= 1461.1 "Enthalpy at Exit ";
   
  parameter Real Vf(unit = "m3")= 1 "Volume of Liquid";
  parameter Real Vg(unit = "m3")= 1 "Volume of Vapor";
  parameter Real V(unit = "m3")= 2 "Volume of Tank";
  
    
equation
mf1= Vf/vf1; 
mg1=Vg/vg1;
m1=mf1+mg1;
m1*u1=(mf1*uf1)+(mg1*ug1);


x2=((m1*(he-u1)*vf2)-2*(he-uf2))/((-2*ufg2)-(vfg2*m1*(he-u1)));



u2=uf2+x2*ufg2;
v2=vf2+x2*vfg2;

m2=V/v2;

me=m1-m2;/*The mass of ammonia withdrawn*/



end Ex6_13;
