model Ex6_4

Real x "Dryness Fraction or Quality of Steam";
Real he(unit = "kJ/kg") "Enthalpy of wet Steam";

   /*Values of Enthalpies are take from Steam Tables at Given T and P As given below*/
   
  parameter Real hi( unit = "kJ/kg")= 2850.1 "Enthalpy of Steam at inlet";
  parameter Real hf( unit = "kJ/kg")= 467.1 "Enthalpy of liquid";
  parameter Real hfg( unit = "kJ/kg")= 2226.5 "Enthalpy of Vapor";
 
  
  parameter Real Vi(unit = "m/s")= 50 "Velocity of Steam at Inlet";
  parameter Real Ve(unit = "m/s")= 600 "Velocity of Steam at Exit";
  
    
equation
 
he= hi+(div(Vi^2,2*1000)-div(Ve^2,2*1000));
x=(he-hf)/hfg;

end Ex6_4;
