model Ex8_5


Real ds( unit = "kJ/kgK") "Change in entropy: s2-s1";
Real ds2( unit = "kJ/kgK") "Change in entropy: s2-s1 for variable specific heat";
    
  parameter Real Cp0( unit = "kJ/kgK")= 1.004 "Specific Heat of Air from Table A.5";
  parameter Real T2( unit = "K")= 600 "Final Temperature";
  parameter Real T1( unit = "K")= 300 "Initial Temperature";
  parameter Real P1( unit = "kPa")= 400 "Final Pressure";
  parameter Real P2( unit = "kPa")= 300 "Initial Pressure";  
  parameter Real R(unit = "kJ/kgK")= 0.287 "Value of R for air";
  parameter Real sT10( unit = "kJ/kgK")= 6.8693 "Standard Entropy at initial conditions";
  parameter Real sT20( unit = "kJ/kgK")= 7.5764 "Standard Entropy at Final Conditons";
      
equation

// Part 1 Constant Specific Heat
ds=Cp0*log(T2/T1)-R*log(P2/P1);

// Part 2 Variable Specific Heat
ds2=sT20-sT10-R*log(P2/P1);

end Ex8_5;
