
model Ex8_6

Real w(unit="kJ/kg") "Work done by air";
Real sT20( unit = "kJ/kgK") "Standard Entropy to be calculated";
    
/*s2=s1 from second law; Q= 0 for adiabatic Process*/    
  parameter Real T2( unit = "K")= 457 "Final Temperature";
  parameter Real P1( unit = "kPa")= 400 "Initial Pressure";
  parameter Real P2( unit = "kPa")= 150 "Final Pressure";  
  parameter Real R(unit = "kJ/kgK")= 0.287 "Value of R for air";
  parameter Real sT10( unit = "kJ/kgK")= 7.5764 "Standard Entropy at initial conditions";
  parameter Real u1(unit="kJ/kg")=435.10 "Value of Internal Energy 1 from Table A.7";
  parameter Real u2(unit="kJ/kg")=328.14 "Value of Internal Energy 2 at 457 K from Table A.7";
    
equation


sT20=sT10+R*log(P2/P1) ;
w=u1-u2;


end Ex8_6;
