model Ex8_8

Real dScm(unit="kJ/K")"Entropy Change in Control Mass";
Real dSsurr(unit="kJ/K")"Entropy Change in surrounding";
Real Qsurr(unit="kJ")"Heat transferred to surrounding";
Real dStot(unit="kJ/K")" Total Entropy Change";
 
  parameter Real m( unit = "kg")= 1 " Mass of Saturated Vapor";
  parameter Real sfg( unit = "kJ/kgK")= 6.0480 "Entropy of Saturated Vapor";
  parameter Real hfg( unit = "kJ/kg")= 2257.0 "Entropy of Saturated Vapor";  
  parameter Real T0(unit = "K")= 298.15 "Standard Temperature";
    
equation

dScm=-m*sfg;
Qsurr=m*hfg;
dSsurr=Qsurr/T0;
dStot=dScm+dSsurr;

end Ex8_8;
