model Ex9_11

Real w(unit="kJ/Kg")"Work Done for Real Process";
Real ws(unit="kJ/Kg")"Work Done in Ideal ISentropic Process";
Real Pi(unit="kPa") "Inlet Pressure";
Real hes(unit="kJ/kg") "Enthalpy of Mixture at Outlet";


/*Values of Entropy and Enthalpy of different straems are calculated from A.7*/
parameter Real sio(unit="kJ/kgK")= 8.6905 "Entropy at State 1";
parameter Real hi(unit="kJ/kg")= 1757.3 "Enthalpy at inlet";
parameter Real he(unit="kJ/kg")= 855.3 "Enthalpy of saturated liquid at outlet";
parameter Real eta=0.85 "Efficiency of Turbine";
parameter Real seso(unit="kJ/kgK")= 7.7148 "Standard Entropy from air Tables ";
parameter Real Tes(unit="K")= 683.7 "Temperature at  exit for isentropic";
parameter Real Pe(unit="kPa")= 100 "Pressure at  exit for isentropic";
parameter Real R(unit="kJ/kgK")= 0.287 "Gas Constant";
 
  equation
w=hi-he /*From First Law*/ ;
ws=w/eta;/*Using the definiition of Turbine efficiency*/ 

 hes=hi-ws;/*From The First Law of Isentropic Process*/
 

Pi=1*Pe/(exp((seso-sio)/R));
  end Ex9_11;
