model Ex9_4

  Real Te(unit = "K") "Temperature at Exit";
  Real wc(unit = "kJ/kg") "Specific Work Required";
  parameter Real Cp0(unit = "kJ/kgK") = 1.004 "Specific heat at Constant Pressure";
  parameter Real k = 1.4 "Index for adiabatic process";
  parameter Real Ti(unit = "K") = 290 "Initial Temperature";
  /*Final Entropy of the Mixture: se=si*/
  parameter Real Pe(unit = "kPa") = 1000 "Exit Pressure";
  parameter Real Pi(unit = "kPa") = 100 "Inlet Pressure";
equation
  Te = Ti * (Pe / Pi) ^ ((k - 1) / k);
  wc = Cp0 * (Ti - Te);
end Ex9_4;
