model Ex10_5

Real psi1(unit="kJ/kg") "Availability at point 1";
Real psi2(unit="kJ/kg") "Availability at point 2";
Real psi3(unit="kJ/kg") "Availability at point 3";
Real h2s(unit="kJ/kg") "Ideal Turbine:Enthalpy at Point 2";
Real h3s(unit="kJ/kg") "Ideal Turbine:Enthalpy at Point 3";
Real Wdots(unit="kJ/kg")"Ideal Turbine:Work";
Real Wdot(unit="kJ/kg") "Actual Turbine:Work";
Real psie(unit="kW") "Decrease in Availability";
Real etas               "Isentropic Efficiency";
Real eta2ndlaw          "2nd Law  Efficiency";
Real x2s "Dryness Fraction at Point 2";
Real x3s "Dryness Fraction at Point 3";

/*At the P ant T of the surroundings, 0.1 MPa, 25 C, the water is slightly compressed liquid, and the properties of the water are essentially equal to those for saturatedliquid at 25 C */
parameter Real Tos(unit="K")      = 298.15 "Standard Temperature";
parameter Real ho(unit="kJ/kg")    = 104.9  " Standard Enthalpy";
parameter Real h1(unit="kJ/kg")    = 3115.3 " Enthalpy at Point 1";
parameter Real so(unit="kJ/kgK")   = 0.3674 " Standard Entropy";
parameter Real s1(unit="kJ/kgK")   = 6.7428 " Entropy at Point 1";
parameter Real h2(unit="kJ/kg")    = 2855.4 " Enthalpy at Point 2";
parameter Real s2(unit="kJ/kgK")   = 7.0592 " Entropy at Point 2";
parameter Real h3(unit="kJ/kg")    = 2361.8 " Enthalpy at Point 3";
parameter Real s3(unit="kJ/kgK")   = 7.2831 " Enthalpy at Point 3";
parameter Real s2s(unit="kJ/kgK") = 6.7428 " Entropy at Point 2";
parameter Real s3s(unit="kJ/kgK") = 6.7428 " Entropy at Point 3 beacuse Isentropic Turbine ";
parameter Real s2sf(unit="kJ/kgK")= 1.8606 " Entropy of sturated liquid at Point 2 ";
parameter Real s2sfg(unit="kJ/kgK") = 4.906 "Entropy corresponding to vaporization at Point 2 ";
parameter Real s3sf(unit="kJ/kgK")= 0.7549 " Entropy of sturated liquid at Point 2 ";
parameter Real s3sfg(unit="kJ/kgK") = 7.2536 "Entropy corresponding to vaporization at Point 2 ";
parameter Real h2sf(unit="kJ/kg") = 640.2  " Enthalpy associated with saturated Liquid at Point 2";
parameter Real h2sfg(unit="kJ/kg")= 2108.5 " Heat of Vaporization at Point 2";
parameter Real h3sf(unit="kJ/kg") = 225.9  " Enthalpy associated with saturated Liquid at point 3";
parameter Real h3sfg(unit="kJ/kg")= 2373.1 " Heat of Vaporization at point 3";

parameter Real mdot1(unit="kg/s")=30 "Mass Flow Rate at point 1";
parameter Real mdot2(unit="kg/s")=5 "Mass Flow Rate at point 2";
parameter Real mdot3(unit="kg/s")=25 "Mass Flow Rate at point 3";

 equation
 
 //The availability at any point
 psi1=(h1-ho)-Tos*(s1-so);
 psi2=(h2-ho)-Tos*(s2-so);
 psi3=(h3-ho)-Tos*(s3-so);
 
 //Calculation of Dryness Fractions at different points
 x2s=(s2s-s2sf)/s2sfg;//In Book Calculation error is made
 x3s=(s3s-s3sf)/s3sfg;
 
 // Calculations of Isentropic Enthalpies at different points
 h2s=h2sf+(x2s*h2sfg);
 h3s=h3sf+(x3s*h3sfg);
 
 // Desrease in Availability
 psie=(mdot1*psi1)-(mdot2*psi2)-(mdot3*psi3);
 
 // Isentropic Work
 Wdots=(mdot1*h1)-(mdot2*h2s)-(mdot3*h3s);
 
 // Actual Work
 Wdot= (mdot1*h1)-(mdot2*h2)-(mdot3*h3);
 
 // Isentropic Efficiency
 etas=Wdot/Wdots;
 
 // Second Law Efficiency
 eta2ndlaw=Wdot/psie;
 
 /* Calculated Value of x2s is wrong in book*/
 /*Answer is slightly varying because of calculation error in h2s*/
 
end Ex10_5;
