model Ex11_4
Real wp1(unit="kJ/kg") "Work into the pump per kg of fluid flowing";
Real wp2(unit="kJ/kg")"Pump Work for high pressure pump";
Real wt(unit="kJ/kg") "Turbine Work";
Real wnet(unit="kJ/kg") "Net Work";
Real h2(unit="kJ/kg")   "Enthalpy at Boiler Inlet";
Real h4(unit="kJ/kg")   "Enthalpy at state 4";
Real qH(unit="kJ/kg")   "Heat Transferred  High Temperature Reservoir";
Real etaT "Thermal Efficiency";
Real y "Extraction Fraction";

parameter Real v1(unit="m3/kg")    =0.00101 "Specific Volume";
parameter Real v2(unit="m3/kg")    =0.0010184 "Specific Volume forhifh Pressure Pump";
parameter Real h1(unit="kJ/kg")   =191.8 "Enthalpy at inlet";
parameter Real h3(unit="kJ/kg")   =604.7 "Enthalpy at state 3 ";
parameter Real P2(unit="kPa")     =400 "Pressureat state 2";
parameter Real P1(unit="kPa")     =10 "Pressure at state 1";
parameter Real P4(unit="kPa")     =4000 "Pressure at state 4";
parameter Real P3(unit="kPa")     =400 "Pressure at sate 3";
parameter Real s4(unit="kJ/kgK")  =6.7690 "Entropy at state 3 equal to state 4";
parameter Real s4f(unit="kJ/kgK") =1.7766 "Entropy of saturated liquid at sate 3/4";
parameter Real s4fg(unit="kJ/kgK")=5.1193 "Entropy at Vaporization";
parameter Real h4f(unit="kJ/kg")  =604.7 "Enthalpy of saturated liquid at sate 3/4";
parameter Real h4fg(unit="kJ/kg") =2133.8 "Enthalpy of Vaporization";
parameter Real h5(unit="kJ/kg")   =3213.6 "Enthalpy at state 5 ";
parameter Real s6(unit="kJ/kgK")  =7.8985 "Entropy at state 5 equal to state 6";
parameter Real s6f(unit="kJ/kgK") =0.6493 "Entropy of saturated liquid at sate 5/6";
parameter Real s6fg(unit="kJ/kgK")=7.50009 "Entropy at Vaporization at state 6";
parameter Real h6(unit="kJ/kg")  =2685.6 "Enthalpy at sate 6";
parameter Real h7(unit="kJ/kg") =2144.11 "Enthalpy at state 7";

 equation
 
 //Calculation of Work and enthalpy
 wp1=v1*(P2-P1);
 h2=h1+wp1;
 
 // Extraction Fraction
 y=(h3-h2)/(h6-h2);
 
 // For High Presure Pump
   wp2=v2*(P4-P3);
   h4=h3+wp2;
 
  // Turbine Work
 wt=(h5-h6)+((1-y)*(h6-h7));
 
   // Net Work
 wnet=wt-((1-y)*wp1)-wp2;
 
 // Energy Transferred to Boiler 
 qH=(h5-h4);

//Thermal Efficieny
etaT=wnet/qH;

/* Thermal Efficiency comes out to be 37.45 %*/

end Ex11_4;
